/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.decorator;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.decorator.EditorPluginImages;
import com.aptana.editor.decorator.IProblemChangedListener;
import com.aptana.editor.epl.EditorEplPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class ProblemsLabelDecorator
implements ILightweightLabelDecorator {
    private static final int ERROR = 2;
    private static final int WARNING = 1;
    private ListenerList fListeners;
    private IProblemChangedListener fProblemChangedListener;

    public void dispose() {
        if (this.fProblemChangedListener != null) {
            EditorEplPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
            this.fProblemChangedListener = null;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add((Object)listener);
        if (this.fProblemChangedListener == null) {
            this.fProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    ProblemsLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            EditorEplPlugin.getDefault().getProblemMarkerManager().addListener(this.fProblemChangedListener);
        }
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.isEmpty() && this.fProblemChangedListener != null) {
                EditorEplPlugin.getDefault().getProblemMarkerManager().removeListener(this.fProblemChangedListener);
                this.fProblemChangedListener = null;
            }
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.fListeners != null && !this.fListeners.isEmpty()) {
            ProblemsLabelChangedEvent event = new ProblemsLabelChangedEvent((IBaseLabelProvider)this, changedResources, isMarkerChange);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged((LabelProviderChangedEvent)event);
                ++i;
            }
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        switch (adornmentFlags) {
            case 2: {
                decoration.addOverlay(EditorPluginImages.DESC_OVR_ERROR);
                break;
            }
            case 1: {
                decoration.addOverlay(EditorPluginImages.DESC_OVR_WARNING);
            }
        }
    }

    protected int computeAdornmentFlags(Object obj) {
        try {
            if (obj instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)obj, 2);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 376) {
                return -1;
            }
            IdeLog.logWarning((Plugin)EditorEplPlugin.getDefault(), (String)"Error computing label-decoration adornment flags", (Throwable)e, (String)"com.aptana.editor.epl/debug");
        }
        return -1;
    }

    private int getErrorTicksFromMarkers(IResource res, int depth) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return -1;
        }
        int info = -1;
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            int i = 0;
            while (i < markers.length && info != 2) {
                IMarker curr = markers[i];
                int severity = curr.getAttribute("severity", -1);
                if (severity == 1) {
                    info = 1;
                } else if (severity == 2) {
                    info = 2;
                }
                ++i;
            }
        }
        return info;
    }

    public static class ProblemsLabelChangedEvent
    extends LabelProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private boolean fMarkerChange;

        public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
            super(eventSource, (Object[])changedResource);
            this.fMarkerChange = isMarkerChange;
        }

        public boolean isMarkerChange() {
            return this.fMarkerChange;
        }
    }
}

